function [ang,ang1] = f_plotto_spiral(r1,r3,X,Y,K,alfaSpiral_deg)
%UNTITLED Summary of this function goes here
%   Detailed explanation goes here

% GEOMETRY DEFINED ACCORDING TO WHIPPLE NGT NOTATION
    % r1 [m] innermost radius
    % r3 [m] external radius
    % X [adim] a1/a2
    % Y [adim] (r3-r2)/(r3-r1)
    % K n. grooves
    % alfaSpiral [°] base angle spiral logaritmica
    % h1 [m] air gap in the groove
    % h2 [m] air gap in the ridges (minimum air gap)
    % n [rpm]
    % pa [Pa] relative ambient pressure of b.c.
    % mu [Pa s]	constant viscosity of air 
    % rho [kg/m3] density


   % NGT spiral groove (WHIPPLE NOTATION)
    %a1=X.*a2
    passo = 2.*pi.*r3./K;
    deltateta = passo./r3;
    a2 = passo./(1+X);
    a1 = passo-a2;
    %b=Y.*(b+c)
    b = Y.*(r3-r1);
    %b=r3-r2;
    %c=r2-r1;
    r2 = r3-b;
    % c=r2-r1;
    alfaSpiral = alfaSpiral_deg/180*pi;

    r=linspace(r2,r3,100);
    angle=-tan(alfaSpiral).*log(r./r3);
    angle1=angle+a1./r3;
    
    % figure()
%     polarplot(linspace(0,2.*pi),r1.*ones(100)./r3,'b','linewidth',2)          %dimensioneless radius
    % polarplot(linspace(0,2.*pi),r1.*ones(100),'b','linewidth',2)
    % hold on
%     polarplot(linspace(0,2.*pi),ones(100),'b','linewidth',2)
    % polarplot(linspace(0,2.*pi),r3*ones(100),'b','linewidth',2)
    % polarplot(angle,r,'b','linewidth',2)
    % polarplot(angle1,r,'b','linewidth',2)
    % polarplot([angle(1) angle1(1)], [r2 r2],'b','linewidth',2)

    for i=1:K
        ang(:,i) = angle+(i-1).*deltateta;
        ang1(:,i) = angle1+(i-1).*deltateta;
%         polarplot(ang(:,i),r./r3,'b','linewidth',2)                           %dimensioneless radius
%         polarplot(ang1(:,i),r./r3,'b','linewidth',2)                          %dimensioneless radius
%         polarplot(linspace(ang(1,i), ang1(1,i),10), r2.*ones(10)./r3,'b','linewidth',2)   %dimensioneless radius
        % polarplot(ang(:,i),r,'b','linewidth',2)
        % polarplot(ang1(:,i),r,'b','linewidth',2)
        % polarplot(linspace(ang(1,i), ang1(1,i),10), r2.*ones(10),'b','linewidth',2)
    end

end

